/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockStepDialog;
import filenet.vw.toolkit.runtime.dialog.VWManageWorkflowGroupsDialog;
import filenet.vw.toolkit.runtime.property.VWAccessModeTableCellRenderer;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.VWStepWflowGroupsTableModel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.table.VWExpandButtonEditor;
import filenet.vw.toolkit.utils.table.VWExpandButtonRenderer;
import filenet.vw.toolkit.utils.table.VWFieldNameRenderer;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWStepWFGroupsPanel
extends VWStepPropTabPanel
implements MouseListener,
IVWMouseActionListener,
IVWPropertyChangeListener {
    private JScrollPane m_tablePanel = null;
    private VWTable m_wflowGroupsTable = null;
    private VWStepWflowGroupsTableModel m_wflowGroupsTableModel = new VWStepWflowGroupsTableModel();
    private VWLockStepDialog m_lockStepDlg = null;
    private AbstractButton m_assignBtn = null;
    private ActionListener m_assignActionListener = null;
    private VWExpandButtonRenderer m_expandBtnRenderer = new VWExpandButtonRenderer();
    private VWExpandButtonEditor m_expandBtnEditor = new VWExpandButtonEditor(new JButton());
    private VWFieldNameRenderer m_fieldNameRenderer = new VWFieldNameRenderer();
    private VWFieldsCellRenderer m_fieldsCellRenderer = new VWFieldsCellRenderer();
    private VWFieldsCellEditor m_fieldsCellEditor = null;
    private VWAccessModeTableCellRenderer m_accessModeRenderer = new VWAccessModeTableCellRenderer();
    private JPanel m_buttonPanel = new JPanel();
    private boolean m_managingWorkflowGroups = false;
    private JPopupMenu m_popup = null;
    private JMenuItem m_miAssign = null;
    private ActionListener m_miAssignActionListener = null;

    public VWStepWFGroupsPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 5;
        this.m_fieldsCellEditor = new VWFieldsCellEditor(this.m_parentFrame);
        this.preSetupLayout();
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        if (this.m_wflowGroupsTableModel == null) {
            this.m_wflowGroupsTableModel = new VWStepWflowGroupsTableModel();
        }
        if (this.m_stepOccurrence != null) {
            if (this.m_bStepView) {
                this.m_wflowGroupsTableModel.setData(this.m_stepOccurrence, true);
            } else if (this.m_participant != null) {
                this.m_wflowGroupsTableModel.setData(this.m_participant, true);
            } else {
                this.m_wflowGroupsTableModel.setData((VWTrkStepOccurrence)null, true);
            }
        } else {
            this.m_wflowGroupsTableModel.clearData();
        }
        this.updateButtonState();
    }

    protected void preSetupLayout() {
        this.m_buttonPanel.setLayout(new FlowLayout(3, 0, 0));
        this.m_assignBtn = VWImageLoader.createToolBarButton("wfgroups.gif", VWResource.s_manageWorkflowGroups, false);
        this.m_assignBtn.setRolloverEnabled(true);
        this.m_buttonPanel.add(this.m_assignBtn);
        this.setLayout(new BorderLayout());
    }

    protected void setupLayout() {
        this.setupTablePane();
        this.add((Component)this.m_buttonPanel, "First");
        this.add((Component)this.m_tablePanel, "Center");
        this.m_assignActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWStepWFGroupsPanel.this.performAssignWorkflowGroup();
            }
        };
        this.m_assignBtn.addActionListener(this.m_assignActionListener);
        this.updateButtonState();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    protected void setupTablePane() {
        TableColumnModel columnModel = null;
        this.m_wflowGroupsTable = new VWTable(this.m_wflowGroupsTableModel);
        this.m_wflowGroupsTable.setRowSelectionAllowed(true);
        this.m_wflowGroupsTable.setSelectionMode(0);
        columnModel = this.m_wflowGroupsTable.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        TableColumn column = null;
        TableColumn columnName = null;
        TableColumn columnMembers = null;
        if (0 < columnCount) {
            column = columnModel.getColumn(0);
            column.setMinWidth(15);
            column.setMaxWidth(15);
            column.setCellRenderer(this.m_expandBtnRenderer);
            column.setCellEditor(this.m_expandBtnEditor);
        }
        if (1 < columnCount) {
            columnName = columnModel.getColumn(1);
            columnName.setCellRenderer(this.m_fieldNameRenderer);
            columnName.setMinWidth(40);
        }
        if (2 < columnCount) {
            columnMembers = columnModel.getColumn(2);
            columnMembers.setMinWidth(80);
            columnMembers.setMinWidth(80);
            columnMembers.setCellRenderer(this.m_fieldsCellRenderer);
            columnMembers.setCellEditor(this.m_fieldsCellEditor);
        }
        this.m_tablePanel = new JScrollPane(this.m_wflowGroupsTable);
        if (columnName != null) {
            columnName.sizeWidthToFit();
        }
        if (columnMembers != null) {
            columnMembers.sizeWidthToFit();
        }
        this.m_wflowGroupsTable.addMouseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEditable(boolean bPrompt) {
        if (!this.isLiveData()) {
            return false;
        }
        if (bPrompt && !this.isDataEditable()) {
            try {
                if (this.m_lockStepDlg == null) {
                    this.m_lockStepDlg = this.m_bStepView ? new VWLockStepDialog(this.m_parentFrame, this.m_stepOccurrence) : new VWLockStepDialog(this.m_parentFrame, this.m_participant);
                    if (this.m_lockStepDlg != null && this.m_lockStepDlg.isAskAgain()) {
                        this.m_lockStepDlg.setVisible(true);
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            finally {
                if (this.m_lockStepDlg != null) {
                    this.m_lockStepDlg.removeReferences();
                    this.m_lockStepDlg = null;
                }
            }
        }
        return this.isDataEditable();
    }

    public void createPopup(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_wflowGroupsTable) {
            return;
        }
        JTable table = (JTable)source;
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        if (col == 2) {
            if (!this.isLiveData()) {
                return;
            }
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
                this.m_miAssign = this.m_popup.add(new JMenuItem(VWResource.s_manageWorkflowGroups));
                this.m_miAssignActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWStepWFGroupsPanel.this.performAssignWorkflowGroup();
                    }
                };
                this.m_miAssign.addActionListener(this.m_miAssignActionListener);
            }
            this.m_popup.show(this.m_wflowGroupsTable, point.x, point.y);
        }
    }

    public void doubleClickedItem(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_wflowGroupsTable) {
            return;
        }
        JTable table = (JTable)source;
        if (table.isEditing()) {
            table.removeEditor();
        }
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        this.performAssignWorkflowGroup();
    }

    protected void updateDisplay() {
        this.stopEditing();
        this.m_wflowGroupsTableModel.fireTableDataChanged();
    }

    private void updateButtonState() {
        if (this.m_assignBtn == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_wflowGroupsTable != null) {
            bEnable = this.m_wflowGroupsTable.getRowCount() > 0;
        }
        this.m_assignBtn.setEnabled(bEnable);
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 701: {
                    this.updateButtonState();
                }
            }
        }
    }

    private void performAssignWorkflowGroup() {
        if (this.m_managingWorkflowGroups) {
            return;
        }
        int row = this.m_wflowGroupsTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        try {
            this.m_managingWorkflowGroups = true;
            if (this.isEditable(true)) {
                Vector workflowGroups = this.m_wflowGroupsTableModel.getData();
                int[] index = new int[2];
                this.m_wflowGroupsTableModel.rowToFieldIndex(row, index);
                VWManageWorkflowGroupsDialog dialog = new VWManageWorkflowGroupsDialog(this.m_parentFrame, workflowGroups, index[0]);
                dialog.setVisible(true);
                if (!dialog.isCanceled()) {
                    this.updateDisplay();
                }
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_parentFrame, e.getLocalizedMessage(), VWResource.s_manageWorkflowGroups, 0, null);
        }
        this.m_managingWorkflowGroups = false;
    }

    public void mouseClicked(MouseEvent evt) {
        this.updateButtonState();
        if (evt.getClickCount() >= 2) {
            this.performAssignWorkflowGroup();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.updateButtonState();
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    protected void stopEditing() {
        if (this.m_fieldsCellEditor != null) {
            this.m_fieldsCellEditor.stopCellEditing();
        }
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_tablePanel != null) {
            this.m_tablePanel.removeAll();
            this.m_tablePanel = null;
        }
        if (this.m_wflowGroupsTable != null) {
            TableColumnModel columnModel = this.m_wflowGroupsTable.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setCellRenderer(null);
                columnModel.getColumn(i).setCellEditor(null);
            }
            this.m_wflowGroupsTable.removeReferences();
            this.m_wflowGroupsTable = null;
        }
        if (this.m_wflowGroupsTableModel != null) {
            this.m_wflowGroupsTableModel.removeReferences();
            this.m_wflowGroupsTableModel = null;
        }
        if (this.m_lockStepDlg != null) {
            this.m_lockStepDlg.removeReferences();
            this.m_lockStepDlg = null;
        }
        if (this.m_assignBtn != null) {
            this.m_assignBtn.removeActionListener(this.m_assignActionListener);
            this.m_assignBtn = null;
        }
        this.m_expandBtnRenderer = null;
        this.m_expandBtnEditor = null;
        this.m_fieldNameRenderer = null;
        this.m_fieldsCellRenderer = null;
        this.m_fieldsCellEditor = null;
        this.m_accessModeRenderer = null;
        if (this.m_buttonPanel != null) {
            this.m_buttonPanel.removeAll();
            this.m_buttonPanel = null;
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miAssign != null) {
            this.m_miAssign.removeActionListener(this.m_miAssignActionListener);
            this.m_miAssign = null;
        }
        this.m_miAssignActionListener = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.removeAll();
    }
}

